/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-2002 Parametric Technology Corporation.
	All rights reserved.
*/

#include <StdAfx.h>
#include "funcheader.h"
#include "CConvenienceExports.h"

int wpcount = 0;
int skcount = 0;

HRESULT TestPlaneOfObject() 
{
	START_METHOD("PlaneOfObject")
	
	HRESULT status=CONV_SUCCESS;
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart=NULL;
	IWorkplane *activeWorkplane=NULL;
	ISet *l_edgeset = NULL , *localGeomset=NULL;
	IPartOthers *part1=NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	AfxMessageBox("Testing PlaneOfObject");

	AfxMessageBox("Select a Face");
	
	status = CommitToProDESKTOP("Selection", TRUE);
	CHECK_RETURN_STATUS(status)

	IGraphic *pGraphic = NULL;
	status = activeGraphicDoc->GetSingleSelection(GetBSTR("Face"), &pGraphic);
	CHECK_RETURN_STATUS(status)
	CHECK_VAR_STATUS(pGraphic)

	ITopology *pFace = CAST(ITopology, pGraphic);
	CHECK_VAR_STATUS(pFace)

	CString str1;
	str1.Format("DemoWorkPlane %d", ++wpcount);
	CString str2;
	str2.Format("DemoSketch %d", ++skcount);

	IWorkplane *pWorkplane = NULL;
	status = PlaneOfObject(pFace, str1, str2, FALSE, 6, &pWorkplane);
	CHECK_RETURN_STATUS(status)

	part1 = CAST(IPartOthers, activePart);

	status = CommitToProDESKTOP("PlaneOfObject");
	CHECK_RETURN_STATUS(status)

	END_METHOD("PlaneOfObject")
}

HRESULT TestOrientedplane() 
{
	START_METHOD("OrientedPlane")
	
	HRESULT status=CONV_SUCCESS;
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart=NULL;
	IWorkplane *activeWorkplane=NULL;
	ISet *l_edgeset = NULL , *localGeomset=NULL;
	IPartOthers *part1=NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)


	// get the design
	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	AfxMessageBox("Testing OrientedPlane");

	AfxMessageBox("Select an Edge");
	
	status = CommitToProDESKTOP("Selection", TRUE);
	CHECK_RETURN_STATUS(status)

	CString str1;
	str1.Format("DemoWorkPlane %d", ++wpcount);
	CString str2;
	str2.Format("DemoSketch %d", ++skcount);

	IGraphic *pGraphic = NULL;
	status = activeGraphicDoc->GetSingleSelection(GetBSTR("Edge"), &pGraphic);
	CHECK_RETURN_STATUS(status)
	CHECK_VAR_STATUS(pGraphic)

	ITopology *pEdge = CAST(ITopology, pGraphic);
	CHECK_VAR_STATUS(pEdge)

	IWorkplane *pWorkplane = NULL;
	status = Orientedplane(pEdge, 0.78,  str1, str2, FALSE, 8, &pWorkplane);
	CHECK_RETURN_STATUS(status)

	part1 = CAST(IPartOthers, activePart);
	
	status = CommitToProDESKTOP("OrientedPlane");
	CHECK_RETURN_STATUS(status)

	END_METHOD("OrientedPlane")
	
}

HRESULT TestPlaneThroughObjects() 
{
	START_METHOD("PlaneThroughObjects")

	HRESULT status=CONV_SUCCESS;
	IGraphicDocument *activeGraphicDoc;
	IPartDocument *activePart=NULL;
	IWorkplane *activeWorkplane=NULL;
	ISet *l_edgeset = NULL , *localGeomset=NULL;
	IPartOthers *part1=NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// get the design
	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	AfxMessageBox("Testing PlaneThroughObject");

	AfxMessageBox("Select Two Edges");

	status = CommitToProDESKTOP("Selection", TRUE);
	CHECK_RETURN_STATUS(status)

	ISet *pedgeset = NULL;
	status = activeGraphicDoc->GetSelection(GetBSTR("Edge"), &pedgeset);
	CHECK_RETURN_STATUS(status)

	IIt *pObjectIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(pedgeset, &pObjectIt);
	CHECK_RETURN_STATUS(status)

	IDispatch *pDisp0 = NULL, *pDisp1 = NULL;
	status = pObjectIt->start(&pDisp0);
	CHECK_RETURN_STATUS(status)

	status = pObjectIt->Next(&pDisp1);
	CHECK_RETURN_STATUS(status)

	ITopology *pEdge0 = NULL, *pEdge1 = NULL;
	pEdge0 = CAST(ITopology, pDisp0);
	CHECK_VAR_STATUS(pEdge0)

	pEdge1 = CAST(ITopology, pDisp1);
	CHECK_VAR_STATUS(pEdge1)

	CString str1;
	str1.Format("DemoWorkPlane %d", ++wpcount);
	CString str2;
	str2.Format("DemoSketch %d", ++skcount);

	IWorkplane *pWorkplane = NULL;
	status = PlaneThroughObjects(pEdge0, pEdge1, str1, str2, FALSE, 7, &pWorkplane);
	CHECK_RETURN_STATUS(status)
	
	status = CommitToProDESKTOP("PlaneThruObjects");
	CHECK_RETURN_STATUS(status)

	END_METHOD("PlaneThroughObjects")
}

HRESULT TestOffsetplane() 
{
	START_METHOD("OffsetPlane")
	
	HRESULT status=CONV_SUCCESS;
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart=NULL;
	IWorkplane *activeWorkplane=NULL;
	ISet *l_edgeset = NULL , *localGeomset=NULL;
	IPartOthers *part1=NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// get the design
	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	AfxMessageBox("Testing OffsetPlane");

	AfxMessageBox("Select a Face");

	status = CommitToProDESKTOP("Selection", TRUE);
	CHECK_RETURN_STATUS(status)

	IGraphic *pGraphic = NULL;
	activeGraphicDoc->GetSingleSelection(GetBSTR("Graphic"), &pGraphic);
	CHECK_RETURN_STATUS(status)
	CHECK_VAR_STATUS(pGraphic)

	ITopology *pFace = CAST(ITopology, pGraphic);
	CHECK_VAR_STATUS(pFace)

	CString str1;
	str1.Format("DemoWorkPlane %d", ++wpcount);
	CString str2;
	str2.Format("DemoSketch %d", ++skcount);

	IWorkplane *pWorkplane = NULL;
	status = Offsetplane(pFace, 0.1, str1, str2, FALSE, 3, &pWorkplane);
	CHECK_RETURN_STATUS(status)

	part1 = CAST(IPartOthers, activePart);
	
	status = CommitToProDESKTOP("OffsetPlane");
	CHECK_RETURN_STATUS(status)

	END_METHOD("OffsetPlane")
}

HRESULT TestMidplane() 
{
	START_METHOD("MidPlane")
	
	HRESULT status=CONV_SUCCESS;
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart=NULL;
	IWorkplane *activeWorkplane=NULL;
	ISet *localGeomset=NULL;
	IPartOthers *part1=NULL;
	IDispatch *retDispatch = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// get the design
	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	AfxMessageBox ("Testing MidPlane");

	AfxMessageBox ("Select two parallel Faces");

	status = CommitToProDESKTOP("Selection", TRUE);
	CHECK_RETURN_STATUS(status)

	ISet *pObjectSet = NULL;
	status = activeGraphicDoc->GetSelection(GetBSTR("Face"), &pObjectSet);
	CHECK_RETURN_STATUS(status)

	long noOfFaces = 0;
	status = pObjectSet->GetCount(&noOfFaces);
	CHECK_RETURN_STATUS(status)
	if (noOfFaces != 2)
		return CONV_FAILURE;

	IIt *pObjectIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(pObjectSet, &pObjectIt);
	CHECK_RETURN_STATUS(status)

	IDispatch *pGeom0 = NULL, *pGeom1 = NULL;
	status = pObjectIt->start(&pGeom0);
	CHECK_RETURN_STATUS(status || pGeom0)

	status = pObjectIt->Next(&pGeom1);
	CHECK_RETURN_STATUS(status || pGeom1)

	ITopology *pFace0 = NULL, *pFace1 = NULL;
	pFace0 = CAST(ITopology, pGeom0);
	CHECK_VAR_STATUS(pFace0)

	pFace1 = CAST(ITopology, pGeom1);
	CHECK_VAR_STATUS(pFace1)

	CString str1;
	str1.Format("DemoWorkPlane %d", ++wpcount);
	CString str2;
	str2.Format("DemoSketch %d", ++skcount);

	IWorkplane *pWorkplane = NULL;
	status = Midplane(pFace0, pFace1, str1, str2, FALSE, 1, &pWorkplane);
	CHECK_RETURN_STATUS(status)
	
	status = CommitToProDESKTOP("MidPlane");
	CHECK_RETURN_STATUS(status)

	END_METHOD("MidPlane")
}

HRESULT TestNewSketch() 
{
	START_METHOD("NewSketch")
	
	HRESULT status=CONV_SUCCESS;
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart=NULL;
	IWorkplane *activeWorkplane=NULL;
	ISet *l_edgeset = NULL , *localGeomset=NULL;
	IPartOthers *part1=NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// get the design
	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	AfxMessageBox("Testing New Sketch");
	
	CString str2;
	str2.Format("DemoSketch %d", ++skcount);

	ISketch *pSketch = NULL;
	status = NewSketch(activeWorkplane, 6, str2.AllocSysString(), &pSketch);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("NewSketch");
	CHECK_RETURN_STATUS(status)

	END_METHOD("NewSketch")
}

HRESULT TestHideOtherSketches() 
{
	START_METHOD("HideOtherSketches")
	
	HRESULT status=CONV_SUCCESS;
	IPartDocument *activePart=NULL;
	IGraphicDocument *activeGraphicDoc = NULL;
	IWorkplane *activeWorkplane=NULL;
	ISet *l_edgeset = NULL , *localGeomset=NULL;
	IPartOthers *part1=NULL;
	IDispatch *retDispatch = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// get the design
	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	// Testing HideOtherSketches
	AfxMessageBox("HideOtherSketches");
	status = HideOtherSketches();
	CHECK_RETURN_STATUS(status)
	
	status = CommitToProDESKTOP("HideSketches");
	CHECK_RETURN_STATUS(status)

	END_METHOD("HideOtherSketches")
}
